/***************************************************************************
 *
 * Copyright (c) 2013,2014 Codethink Limited
 *
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 ****************************************************************************/

#ifndef INPUT_DEVICE_CONFIGURATION_H_INCLUDED
#define INPUT_DEVICE_CONFIGURATION_H_INCLUDED

#include <sys/types.h>

#include <fstream>
#include <list>
#include <map>
#include <string>

#include "Subdivision.h"
#include "Calibration.h"

using namespace std;

namespace LayerManagerCalibration
{
    class InputDeviceConfiguration
    {
    public:
        InputDeviceConfiguration();
        ~InputDeviceConfiguration();
        bool parseFile(const string& fileName);
        const list<string*>& getDeviceNames() const;
        const list<Subdivision*>& getSubdivisions();
        bool getSubdivisionForCoordinate(const coordinate& raw,
                                         Subdivision** subdivision,
                                         coordinate& resultingCoordinate);
        bool getRawCoordinate(const string& subdivisionName,
                              const coordinate& logical,
                              coordinate& raw,
                              uint dispWidth,
                              uint dispHeight,
                              bool useCalibration);
        Calibration& getCalibration();
        const string& getCalibrationFileName();

    private:
        list<string*> m_DeviceNames;
        string m_calibrationFileName;
        list<Subdivision*> m_Subdivisions;
        Calibration m_calibration;

        bool m_bDeviceNameParsed;
    };

    inline InputDeviceConfiguration::InputDeviceConfiguration()
        : m_bDeviceNameParsed(false)
    {
    }

    inline const list<string*>& InputDeviceConfiguration::getDeviceNames() const
    {
        return m_DeviceNames;
    }

    inline const list<Subdivision*>& InputDeviceConfiguration::getSubdivisions()
    {
        return m_Subdivisions;
    }

    inline const string& InputDeviceConfiguration::getCalibrationFileName()
    {
        return m_calibrationFileName;
    }

    inline Calibration& InputDeviceConfiguration::getCalibration()
    {
        return m_calibration;
    }

    typedef map<string,InputDeviceConfiguration*> InputDeviceConfigurationMap;
}

#endif
